#ifndef SYSTEM_H
#define SYSTEM_H

#include "User_api.h"
#include "Loss_generator.h"
#include "Log.h"
#include <ctime>
#include "windows.h"
#include "psapi.h"
#include <thread>

NN_data NN_DATA;
User_parameter USER_PARAMETER;
NN_parameter NN_PARAMETER;
app1_indata INDATA = { {}, {}, {} };
app1_solution SOLUTION = { {},{},{},{},{} };
app1_gradient GRADIENT = { {}, {}, {} };
problem pr;
User_api USER_API("NN_function", &NN_DATA, &USER_PARAMETER, &NN_PARAMETER, &GRADIENT);



void POF_INITIALIZATION(int* n_dataset_index) {
	cout << "\n  System:: INITIALIZATION start" << endl;
		USER_API.load_dataset(n_dataset_index);
		cout << "  System:: INITIALIZATION complete\n" << endl;
}


void POF_TRAIN_BATCH(vector<int> train_sample_index_array, vector<int> train_internal_test_index_array,
	double dropout, double alpha, double lr, double weight_decay,
	int n_rank, double th,  double beta, double lambda, double xi) {
	Loss_generator LOSS_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION);
	cout << "\n  System:: TRAIN(1STEP) start" << endl;
	clock_t start = std::clock();
	USER_API.set_nnparameters(dropout, alpha, lr, weight_decay);
	USER_API.update_nndata_batch(1, train_sample_index_array, train_internal_test_index_array);
	int n_sample = USER_API.get_userparameter_int("n_sample");
	int n_internal_test_case = static_cast<int>(train_internal_test_index_array.size());
	USER_API.set_userparameters(n_internal_test_case, n_rank, th, beta, lambda, xi);
	SOLUTION = { {},{},{},{},{} };
	double approx_loss = 0, best_loss = 0, ulti_best_loss = 0;
	for (int sample_order = 0;sample_order < NN_DATA.n_sample;sample_order++)
	{
		approx_loss += LOSS_GENERATOR.calc_approx_loss_batch(sample_order, 1);
					}
	int max_vio = 0;
	for (int l = 0;l < 4;l++)
		max_vio = max_vio > SOLUTION.vio[l] ? max_vio : SOLUTION.vio[l];
	write_log("TRAIN", th, approx_loss, max_vio);

	USER_API.set_userparameter("lambda_decay", 0.999);
	cout << "  System:: TRAIN(1STEP) complete" << endl;
}

app1_solution POF_UTILIZATION(int mode, vector<int> val_sample_index_array, vector<int> internal_test_index_array,
	int n_rank, double th, double beta, double lambda, double xi) {
	Loss_generator LOSS_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION);
	cout << "\n  System:: UTILIZATION(1STEP) start" << endl;
	int n_internal_test_case = static_cast<int>(internal_test_index_array.size());

	USER_API.set_userparameters(n_internal_test_case, n_rank, th, beta, lambda, xi);
	SOLUTION = { {},{},{},{},{} };
	USER_API.update_nndata_batch(2, val_sample_index_array, internal_test_index_array);
	
	for (int sample_order = 0;sample_order < NN_DATA.n_sample;sample_order++)
	{
		LOSS_GENERATOR.ulti_best_loss_batch(sample_order);
		LOSS_GENERATOR.best_loss_batch(sample_order);
		LOSS_GENERATOR.get_solution(sample_order);
	}
	cout << "  System:: UTILIZATION(1STEP) complete\n" << endl;
	return SOLUTION;
}

void POF_FINALIZATION() {
	cout << "\n  System:: FINALIZATION start" << endl;
	USER_API.clear();
	close_log_loss_file();
	cout << "  System:: FINALIZATION complete\n" << endl;
}

#endif
